// XISLIfTag.cpp: CXISLIfTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLIfTag.h"
#include "XISLIfChildTag.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLIfTag::CXISLIfTag(int nType)
{
	m_nTagType = nType;
	if(nType==ID_TAG_IF)
		m_nBmpID = IDB_CONDITION;
	else if(nType == ID_TAG_ELSEIF)
		m_nBmpID = IDB_ELSEIF;

	m_pParentTag = NULL;
	m_pThenTag = new CXISLIfChildTag(ID_TAG_THEN,this);
	m_pElseIfTag = NULL;
	m_pElseTag = NULL;
}

CXISLIfTag::~CXISLIfTag()
{
	delete m_pThenTag;
	if(m_pElseIfTag)
		delete m_pElseIfTag;
	if(m_pElseTag)
		delete m_pElseTag;
}

CXISLIfTag::CXISLIfTag(const CXISLIfTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	m_pElseIfTag = cpXISL.m_pElseIfTag;
	m_pThenTag = cpXISL.m_pThenTag;
	m_pElseTag = cpXISL.m_pElseTag;
}

CXISLIfTag& CXISLIfTag::operator=(const CXISLIfTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		m_pElseIfTag = cpXISL.m_pElseIfTag;
		m_pThenTag = cpXISL.m_pThenTag;
		m_pElseTag = cpXISL.m_pElseTag;
	}
	return *this;
}

CXISLIfChildTag* CXISLIfTag::CreateElseTag()
{
	if(m_pElseTag==NULL)
		m_pElseTag = new CXISLIfChildTag(ID_TAG_ELSE,this);
	else
		AfxMessageBox("<else>͊ɑ݂܂");
	return m_pElseTag;
}

void CXISLIfTag::AddElseIfTag(CXISLIfTag *pEITag)
{
	if(pEITag->m_nTagType != ID_TAG_ELSEIF)
		ASSERT(NULL);

	m_pElseIfTag = pEITag;
	m_pElseIfTag->m_pParentTag = this;
	//else^O𐶐ĂEEE
	if(m_pElseTag)
	{
		//ɒǉelseif^Oelse^OĂ
		if(m_pElseIfTag->m_pElseTag)
			delete m_pElseTag;//else^O͍폜
		else
		{
			//ĂȂȂ玩else^Oړ
			m_pElseIfTag->m_pElseTag = m_pElseTag;
			m_pElseTag = NULL;
		}
	}
}

BOOL CXISLIfTag::SetAttribute(LPCTSTR lpszCond)
{
	m_strCond = lpszCond;
	return TRUE;
}

LPCTSTR CXISLIfTag::GetXISLString()
{
	m_strXISL = "<";
	m_strXISL += XISL_TAG_NAME[m_nTagType];
	m_strXISL += " cond = \"";
	m_strXISL += m_strCond;
	m_strXISL += "\">\r\n";

	m_strXISL += m_pThenTag->GetXISLString();

	if(m_pElseIfTag)
		m_strXISL += m_pElseIfTag->GetXISLString();
	else if(m_pElseTag)
		m_strXISL += m_pElseTag->GetXISLString();

	m_strXISL += "</";
	m_strXISL += XISL_TAG_NAME[m_nTagType];
	m_strXISL += ">\r\n";
	return m_strXISL;
}

//BOOL CXISLIfTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLIfTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[m_nTagType];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	m_pThenTag->RegistXISLTree(pTree,hParent);

	if(m_pElseIfTag)
		m_pElseIfTag->RegistXISLTree(pTree,hParent);

	else if(m_pElseTag)
		m_pElseTag->RegistXISLTree(pTree,hParent);

	return TRUE;
}

//CXISLTag* CXISLIfTag::FindTag(POINT point,BOOL bOnly)
//@\@FNbNꂽ^OT
//@Fpoint:W
//		  bOnly:TRUE͎̎ĝݔf
//ԂlFY^OBNULL
CXISLTag* CXISLIfTag::FindTag(POINT point,BOOL bOnly)
{
	m_rectBMP.NormalizeRect();
	if(m_rectBMP.PtInRect(point))
		return (CXISLTag*)this;
	else if(!bOnly)
	{
		CXISLTag* pTag = m_pThenTag->FindTag(point,TRUE);
		if(pTag)
			return pTag;
		
		if(m_pElseIfTag)
		{
			pTag = m_pElseIfTag->FindTag(point,TRUE);
			if(pTag)
				return pTag;
		}

		if(m_pElseTag)
		{
			pTag = m_pElseTag->FindTag(point,TRUE);
			if(pTag)
				return pTag;
		}
	}

	return NULL;
}

//CSize CXISLSwitchTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
//@\@Fexchange̗}
//@FCDC *pDC:foCXReLXg
//		  int nX, nY:`Jnʒu
//ԂlFCSize:`͈
CSize CXISLIfTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
{
	int nViewSizeX,nViewSizeY;

	CDC MemDC;
	MemDC.CreateCompatibleDC(pDC);
		
	CBitmap FlowBMP;
	BITMAP bmp;

	FlowBMP.LoadBitmap(m_nBmpID);

	FlowBMP.GetBitmap(&bmp);
	CBitmap *pOldBMP = MemDC.SelectObject(&FlowBMP);

	pDC->BitBlt(nX,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
	FlowBMP.DeleteObject();
	SetRectBMP(nX,nY,bmp.bmWidth,bmp.bmHeight);

	nX += bmp.bmWidth/2;
	nY += bmp.bmHeight-1;

	pDC->MoveTo(nX,nY);
	POINT point[3];
	point[0].x = nX;
	nY += 20;
	point[0].y = nY;
	nX += bmp.bmWidth;
	point[1].x = nX+5;
	point[1].y = nY;
	point[2].x = nX;
	nY += 35;
	point[2].y = nY;

	CPen *pOldPen,linePen;
	linePen.CreatePen(PS_SOLID,3,RGB(0,0,0));
	pOldPen = pDC->SelectObject(&linePen);
	
	//XvCȐ̍쐬
	pDC->PolyBezierTo(point,3);
		
	CFont *pOldFont;
	CFont font;
	font.CreateFont(12,0,0,0,FW_BOLD,TRUE,FALSE,FALSE,
		SHIFTJIS_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
		DRAFT_QUALITY,DEFAULT_PITCH,_T("lr oSVbN"));
	pOldFont = pDC->SelectObject(&font);
	pDC->SetTextColor(RGB(80,80,80));
	pDC->SetBkMode(TRANSPARENT);
	CString strText = GetCond();
	pDC->DrawText(strText,m_rectBMP,DT_CENTER|DT_NOCLIP|DT_VCENTER|DT_SINGLELINE);

//	int nCount = m_CaseList.GetCount();
//	int *npPoint = new int[nCount];
	int i=0,nStartX=nX,nStartY=nY;
	//
	if(m_pThenTag!=NULL){
		//^OBMP[h
		FlowBMP.LoadBitmap(m_pThenTag->m_nBmpID);
		FlowBMP.GetBitmap(&bmp);
		//FlowBMPIuWFNgZbg
		MemDC.SelectObject(&FlowBMP);
		pDC->BitBlt(nX-bmp.bmWidth/2,nY+10,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
		FlowBMP.DeleteObject();
		m_pThenTag->SetRectBMP(nX-bmp.bmWidth/2,nY+10,bmp.bmWidth,bmp.bmHeight);
		pDC->MoveTo(nX,nY);
		pDC->LineTo(nX,nY+10);
		//̐ݒ
		CRect rect;
		m_pThenTag->GetRectBMP(&rect);
		pDC->DrawText("THEN",rect,DT_CENTER|DT_NOCLIP|DT_VCENTER|DT_SINGLELINE);
	}
	if(m_pElseTag!=NULL){
		//^OBMP[h
		FlowBMP.LoadBitmap(m_pElseTag->m_nBmpID);
		FlowBMP.GetBitmap(&bmp);
		nX = nX + bmp.bmWidth + 50;
		//FlowBMPIuWFNgZbg
		MemDC.SelectObject(&FlowBMP);
		pDC->BitBlt(nX-bmp.bmWidth/2,nY+10,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
		FlowBMP.DeleteObject();
		m_pElseTag->SetRectBMP(nX-bmp.bmWidth/2,nY+10,bmp.bmWidth,bmp.bmHeight);
		pDC->MoveTo(nX,nY);
		pDC->LineTo(nX,nY+10);
		pDC->MoveTo(nStartX,nStartY);
		pDC->LineTo(nX,nStartY);
		//̐ݒ
		CRect rect;
		m_pElseTag->GetRectBMP(&rect);
		pDC->DrawText("ELSE",rect,DT_CENTER|DT_NOCLIP|DT_VCENTER|DT_SINGLELINE);
	}
	if(m_pElseIfTag!=NULL){
		//^OBMP[h
		FlowBMP.LoadBitmap(m_pElseIfTag->m_nBmpID);
		FlowBMP.GetBitmap(&bmp);
		nX = nX + bmp.bmWidth + 50;
		//FlowBMPIuWFNgZbg
		MemDC.SelectObject(&FlowBMP);
		pDC->BitBlt(nX-bmp.bmWidth/2,nY+40,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
		FlowBMP.DeleteObject();
		m_pElseIfTag->SetRectBMP(nX-bmp.bmWidth/2,nY+40,bmp.bmWidth,bmp.bmHeight);
		point[0].x = nStartX;
		point[0].y = nStartY-20;
		point[1].x = nX;
		point[1].y = nY;
		point[2].x = nX;
		point[2].y = nY+40;
		//XvCȐ̍쐬
		pDC->PolyBezierTo(point,3);

	/*	pDC->MoveTo(nX,nY);
		pDC->LineTo(nX,nY+40);
		pDC->MoveTo(nStartX,nStartY);
		pDC->LineTo(nX,nStartY);*/
		//̐ݒ
		strText = m_pElseIfTag->GetCond();
		CRect rect;
		m_pElseIfTag->GetRectBMP(&rect);
		pDC->DrawText(strText,rect,DT_CENTER|DT_NOCLIP|DT_VCENTER|DT_SINGLELINE);
	}
//	npPoint[i] = nX;
	/*nX = nX + bmp.bmWidth + 20;

	CString strText = m_pThenTag->();
	CRect rect;
	m_pThenTag->GetRectBMP(&rect);
	pDC->DrawText(strText,rect,DT_CENTER|DT_NOCLIP|DT_VCENTER|DT_SINGLELINE);*/
/*	POSITION pos = m_CaseList.GetHeadPosition();
	while(pos)
	{
		CXISLCaseTag *pCTag = (CXISLCaseTag*)m_CaseList.GetNext(pos);
		FlowBMP.LoadBitmap(pCTag->m_nBmpID);
		FlowBMP.GetBitmap(&bmp);

		MemDC.SelectObject(&FlowBMP);
		pDC->BitBlt(nX-bmp.bmWidth/2,nY+10,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
		FlowBMP.DeleteObject();
		pCTag->SetRectBMP(nX-bmp.bmWidth/2,nY+10,bmp.bmWidth,bmp.bmHeight);
		npPoint[i] = nX;
		nX = nX + bmp.bmWidth + 20;

		strText = pCTag->GetValue();
		CRect rect;
		pCTag->GetRectBMP(&rect);
		pDC->DrawText(strText,rect,DT_CENTER|DT_NOCLIP|DT_VCENTER|DT_SINGLELINE);
		i++;
	}

	pDC->MoveTo(nStartX,nStartY);
	pDC->LineTo(npPoint[nCount-1],nStartY);
	for(i=0;i<nCount;i++)
	{
		pDC->MoveTo(npPoint[i],nY);
		pDC->LineTo(npPoint[i],nY+10);
	}
*/
//	delete [] npPoint;
	nViewSizeX = nX + bmp.bmWidth/2;
	nViewSizeY = nY + bmp.bmHeight;
	MemDC.SelectObject(pOldBMP);
	pDC->SelectObject(pOldFont);
	FlowBMP.DeleteObject();
	MemDC.DeleteDC();

/*	CString strText;
	CRect rect;
	m_pThenTag->GetRectBMP(&rect);
	pDC->DrawText(strText,rect,DT_CENTER|DT_NOCLIP|DT_VCENTER|DT_SINGLELINE);
	m_pThenTag->DrawXISLFlow(pDc,rect*/

	return CSize(nViewSizeX+100,nViewSizeY+100);
}

//SẴ^O폜
//2003/6/2@
void CXISLIfTag::DeleteALL()
{
	DeleteThen();
	DeleteElse();
	DeleteElseIf();
}

void CXISLIfTag::DeleteThen()
{
	if(m_pThenTag!=NULL){
		m_pThenTag->DeleteItem();
		delete m_pThenTag;
		m_pThenTag=NULL;
	}
}

void CXISLIfTag::DeleteElse()
{
	if(m_pElseTag!=NULL){
		m_pElseTag->DeleteItem();
		delete m_pElseTag;
		m_pElseTag=NULL;
	}
}

void CXISLIfTag::DeleteElseIf()
{
	if(m_pElseIfTag!=NULL){
		m_pElseIfTag->DeleteALL();
		delete m_pElseIfTag;
		m_pElseIfTag=NULL;
	}
}